<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%user}}`.
 */
class m251221_154951_create_user_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%user}}', [
            'id' => $this->primaryKey(),
            'full_name' => $this->string(255)->notNull(),
            'phone' => $this->string(20)->notNull()->unique(),
            'email' => $this->string(255)->notNull()->unique(),
            'password_hash' => $this->string(255)->notNull(),
            'auth_key' => $this->string(32)->null(),
            'access_token' => $this->string(255)->null(),
            'is_admin' => $this->boolean()->defaultValue(false),
            'agreed_to_terms' => $this->boolean()->defaultValue(false),
            'created_at' => $this->integer()->notNull(),
            'updated_at' => $this->integer()->notNull(),
        ]);
         $this->insert('{{%user}}', [
            'full_name' => 'Администратор',
            'phone' => '+7(999)999-99-99',
            'email' => 'admin@mail.ru',
            'password_hash' => Yii::$app->security->generatePasswordHash('adminka'),
            'auth_key' => Yii::$app->security->generateRandomString(),
            'is_admin' => true,
            'agreed_to_terms' => true,
            'created_at' => time(),
            'updated_at' => time(),
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%user}}');
    }
}
