<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;

class EmployeeProfileSearch extends EmployeeProfile
{
    public $user_full_name;
    public $user_email;
    public $user_phone;

    public function rules()
    {
        return [
            [['id', 'user_id', 'work_experience'], 'integer'],
            [['gender', 'citizenship', 'education', 'position', 'marital_status', 'status'], 'safe'],
            [['user_full_name', 'user_email', 'user_phone'], 'safe'],
        ];
    }

    public function scenarios()
    {
        return Model::scenarios();
    }

    public function search($params)
    {
        $query = EmployeeProfile::find()->joinWith(['user']);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 20,
            ],
            'sort' => [
                'defaultOrder' => [
                    'created_at' => SORT_DESC,
                ],
                'attributes' => [
                    'id',
                    'birth_date',
                    'gender',
                    'citizenship',
                    'education',
                    'work_experience',
                    'position',
                    'marital_status',
                    'status',
                    'created_at',
                    'user_full_name' => [
                        'asc' => ['user.full_name' => SORT_ASC],
                        'desc' => ['user.full_name' => SORT_DESC],
                    ],
                    'user_email' => [
                        'asc' => ['user.email' => SORT_ASC],
                        'desc' => ['user.email' => SORT_DESC],
                    ],
                    'user_phone' => [
                        'asc' => ['user.phone' => SORT_ASC],
                        'desc' => ['user.phone' => SORT_DESC],
                    ],
                ],
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            return $dataProvider;
        }

        // Фильтрация по связанной таблице User
        $query->andFilterWhere(['like', 'user.full_name', $this->user_full_name])
              ->andFilterWhere(['like', 'user.email', $this->user_email])
              ->andFilterWhere(['like', 'user.phone', $this->user_phone]);

        // Фильтрация по основным полям
        $query->andFilterWhere([
            'employee_profile.gender' => $this->gender,
            'employee_profile.citizenship' => $this->citizenship,
            'employee_profile.education' => $this->education,
            'employee_profile.position' => $this->position,
            'employee_profile.marital_status' => $this->marital_status,
            'employee_profile.status' => $this->status,
        ]);

        // Фильтрация по стажу работы
        if ($this->work_experience !== null && $this->work_experience !== '') {
            $query->andFilterWhere(['employee_profile.work_experience' => $this->work_experience]);
        }

        return $dataProvider;
    }
}