<?php
use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use yii\bootstrap5\ActiveForm;
use app\models\EmployeeProfile; // Добавлена эта строка

$this->title = 'Панель администратора';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-index">
    <div class="admin-header">
        <h1 class="admin-title">Панель администратора</h1>
        <p class="admin-subtitle">Управление анкетами сотрудников</p>
    </div>

    <!-- Фильтры -->
    <div class="filter-card">
        <div class="filter-header">
            <h3 class="filter-title">🔍 Фильтры и поиск</h3>
            <?= Html::a('Сбросить фильтры', ['index'], ['class' => 'btn btn-outline btn-sm']) ?>
        </div>
        
        <?php $form = ActiveForm::begin([
            'method' => 'get',
            'options' => ['class' => 'filter-form']
        ]); ?>
        
        <div class="row">
            <div class="col-md-3">
                <?= $form->field($searchModel, 'user_full_name')->textInput(['placeholder' => 'Поиск по ФИО']) ?>
            </div>
            <div class="col-md-3">
                <?= $form->field($searchModel, 'user_email')->textInput(['placeholder' => 'Поиск по email']) ?>
            </div>
            <div class="col-md-3">
                <?= $form->field($searchModel, 'user_phone')->textInput(['placeholder' => 'Поиск по телефону']) ?>
            </div>
            <div class="col-md-3">
                <?= $form->field($searchModel, 'status')->dropDownList(EmployeeProfile::getStatuses(), ['prompt' => 'Все статусы']) ?>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-3">
                <?= $form->field($searchModel, 'gender')->dropDownList($genders, ['prompt' => 'Все полы']) ?>
            </div>
            <div class="col-md-3">
                <?= $form->field($searchModel, 'citizenship')->dropDownList($citizenships, ['prompt' => 'Все гражданства']) ?>
            </div>
            <div class="col-md-3">
                <?= $form->field($searchModel, 'education')->dropDownList($educations, ['prompt' => 'Все образования']) ?>
            </div>
            <div class="col-md-3">
                <?= $form->field($searchModel, 'marital_status')->dropDownList($maritalStatuses, ['prompt' => 'Все семейные положения']) ?>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-6">
                <?= $form->field($searchModel, 'position')->dropDownList($positions, ['prompt' => 'Все должности']) ?>
            </div>
            <div class="col-md-6">
                <?= $form->field($searchModel, 'work_experience')->textInput(['placeholder' => 'Стаж работы (лет)']) ?>
            </div>
        </div>
        
        <div class="form-group text-center">
            <?= Html::submitButton('Применить фильтры', ['class' => 'btn btn-primary']) ?>
        </div>
        
        <?php ActiveForm::end(); ?>
    </div>

    <!-- Статистика -->
    <div class="stats-cards">
        <div class="stat-card">
            <div class="stat-icon">📋</div>
            <div class="stat-content">
                <div class="stat-number"><?= $dataProvider->totalCount ?></div>
                <div class="stat-label">Всего анкет</div>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon">🆕</div>
            <div class="stat-content">
                <div class="stat-number"><?= EmployeeProfile::find()->where(['status' => 'Новая'])->count() ?></div>
                <div class="stat-label">Новые</div>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon">⏳</div>
            <div class="stat-content">
                <div class="stat-number"><?= EmployeeProfile::find()->where(['status' => 'Идет проверка данных'])->count() ?></div>
                <div class="stat-label">В проверке</div>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon">✅</div>
            <div class="stat-content">
                <div class="stat-number"><?= EmployeeProfile::find()->where(['status' => 'Данные приняты'])->count() ?></div>
                <div class="stat-label">Принято</div>
            </div>
        </div>
    </div>

    <!-- Таблица с анкетами -->
    <div class="table-card">
        <?php Pjax::begin(); ?>
        <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'tableOptions' => ['class' => 'table table-striped table-hover'],
            'columns' => [
                [
                    'attribute' => 'id',
                    'header' => 'ID',
                    'headerOptions' => ['style' => 'width: 80px'],
                    'contentOptions' => ['class' => 'text-center']
                ],
                [
                    'attribute' => 'user_full_name',
                    'header' => 'ФИО',
                    'value' => 'user.full_name'
                ],
                [
                    'attribute' => 'user_email',
                    'header' => 'Email',
                    'value' => 'user.email'
                ],
                [
                    'attribute' => 'position',
                    'header' => 'Должность'
                ],
                [
                    'attribute' => 'education',
                    'header' => 'Образование'
                ],
                [
                    'attribute' => 'work_experience',
                    'header' => 'Стаж (лет)',
                    'contentOptions' => ['class' => 'text-center']
                ],
                [
                    'attribute' => 'status',
                    'header' => 'Статус',
                    'content' => function($model) {
                        $statusClass = '';
                        switch ($model->status) {
                            case 'Новая': $statusClass = 'status-new'; break;
                            case 'Идет проверка данных': $statusClass = 'status-in-progress'; break;
                            case 'Данные приняты': $statusClass = 'status-accepted'; break;
                        }
                        return '<span class="' . $statusClass . '">' . $model->status . '</span>';
                    }
                ],
                [
                    'attribute' => 'created_at',
                    'header' => 'Дата создания',
                    'format' => 'datetime',
                    'headerOptions' => ['style' => 'width: 180px']
                ],
                [
                    'class' => 'yii\grid\ActionColumn',
                    'header' => 'Действия',
                    'template' => '{view} {status}',
                    'headerOptions' => ['style' => 'width: 150px'],
                    'contentOptions' => ['class' => 'action-buttons'],
                    'buttons' => [
                        'view' => function ($url, $model) {
                            return Html::a('👁️ Просмотр', ['view', 'id' => $model->id], [
                                'class' => 'btn btn-sm btn-outline',
                                'title' => 'Просмотр анкеты'
                            ]);
                        },
                        'status' => function ($url, $model) {
                            $statuses = EmployeeProfile::getStatuses();
                            $items = [];
                            foreach ($statuses as $key => $value) {
                                if ($key !== $model->status) {
                                    $items[] = Html::a($value, ['update-status', 'id' => $model->id, 'status' => $key], [
                                        'data' => ['method' => 'post'],
                                        'class' => 'dropdown-item'
                                    ]);
                                }
                            }
                            return '<div class="dropdown">
                                <button class="btn btn-sm btn-outline dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                    📝 Статус
                                </button>
                                <div class="dropdown-menu">' . implode('', $items) . '</div>
                            </div>';
                        },
                    ],
                ],
            ],
        ]); ?>
        <?php Pjax::end(); ?>
    </div>
</div>