<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">
<head>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body class="d-flex flex-column h-100">
<?php $this->beginBody() ?>

<header class="header">
    <div class="container">
        <div class="header-content">
            <a href="<?= Yii::$app->homeUrl ?>" class="logo">
                🏢 HR-Portal
            </a>

            <nav class="nav">
                <ul class="nav-menu">
                    <!-- Ссылка на главную для всех -->
                    <li class="nav-item">
                        <?= Html::a('Главная', ['site/index'], ['class' => 'nav-link']) ?>
                    </li>
                    
                    <?php if (Yii::$app->user->isGuest): ?>
                        <li class="nav-item">
                            <?= Html::a('Войти', ['site/login'], ['class' => 'nav-link']) ?>
                        </li>
                        <li class="nav-item">
                            <?= Html::a('Регистрация', ['site/register'], ['class' => 'nav-link']) ?>
                        </li>
                    <?php else: ?>
                        <!-- Для админа показываем все ссылки -->
                        <?php if (Yii::$app->user->identity->is_admin): ?>
                            <li class="nav-item">
                                <?= Html::a('Панель администратора', ['admin/index'], ['class' => 'nav-link']) ?>
                            </li>
                            <li class="nav-item">
                                <?= Html::a('Анкета', ['profile/questionnaire'], ['class' => 'nav-link']) ?>
                            </li>
                            <li class="nav-item">
                                <?= Html::a('Личный кабинет', ['profile/cabinet'], ['class' => 'nav-link']) ?>
                            </li>
                        <?php else: ?>
                            <!-- Для обычных пользователей -->
                            <li class="nav-item">
                                <?= Html::a('Анкета', ['profile/questionnaire'], ['class' => 'nav-link']) ?>
                            </li>
                            <li class="nav-item">
                                <?= Html::a('Личный кабинет', ['profile/cabinet'], ['class' => 'nav-link']) ?>
                            </li>
                        <?php endif; ?>
                        
                        <li class="nav-item user-info-item">
                            <span class="user-info">
                                <span class="welcome-text"><?= Html::encode(Yii::$app->user->identity->full_name) ?></span>
                                <?php if (Yii::$app->user->identity->is_admin): ?>
                                    <span class="admin-badge">Админ</span>
                                <?php endif; ?>
                            </span>
                        </li>
                        <li class="nav-item">
                            <?= Html::a('Выйти', ['site/logout'], [
                                'class' => 'nav-link logout-link',
                                'data' => ['method' => 'post']
                            ]) ?>
                        </li>
                    <?php endif; ?>
                </ul>
            </nav>
        </div>
    </div>
</header>

<main id="main" class="flex-shrink-0" role="main">
    <div class="container">
        <?php if (!empty($this->params['breadcrumbs'])): ?>
            <?= Breadcrumbs::widget(['links' => $this->params['breadcrumbs']]) ?>
        <?php endif ?>
        <?= Alert::widget() ?>
        <?= $content ?>
    </div>
</main>

<footer class="footer mt-auto py-3 bg-light">
    <div class="container">
        <div class="footer-content">
            <div class="footer-logo">🏢 HR-Portal</div>
            <div class="footer-text">
                &copy; <?= date('Y') ?> HR-Portal. Все права защищены.
            </div>
            <div class="footer-links">
                <a href="#" class="footer-link">Политика конфиденциальности</a>
                <a href="#" class="footer-link">Условия использования</a>
                <a href="#" class="footer-link">Поддержка</a>
            </div>
        </div>
    </div>
</footer>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>