<?php
use yii\helpers\Html;
use yii\bootstrap5\ActiveForm;

$this->title = 'Регистрация';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="form-container">
    <h1 class="form-title">Регистрация</h1>

    <?php $form = ActiveForm::begin([
        'id' => 'register-form',
        'fieldConfig' => [
            'template' => "{label}\n{input}\n{error}",
            'labelOptions' => ['class' => 'form-label'],
            'inputOptions' => ['class' => 'form-control'],
            'errorOptions' => ['class' => 'help-block'],
        ],
    ]); ?>

    <?= $form->field($model, 'full_name')->textInput([
        'autofocus' => true,
        'placeholder' => 'Иванов Иван Иванович'
    ]) ?>

    <div class="form-group">
        <label class="form-label" for="registerform-phone">Телефон</label>
        <div class="phone-input-container">
            <input 
                type="tel" 
                id="registerform-phone" 
                class="form-control phone-input" 
                name="RegisterForm[phone]" 
                value="<?= Html::encode($model->phone) ?>" 
                placeholder="+7(999)999-99-99" 
                pattern="\+7\(\d{3}\)\d{3}-\d{2}-\d{2}" 
                title="Введите телефон в формате: +7(999)999-99-99" 
                inputmode="tel" 
                required 
                oninput="formatPhone(this)"
            />
            <div class="phone-format">Формат: +7(XXX)XXX-XX-XX</div>
        </div>
        <?php if ($model->hasErrors('phone')): ?>
            <div class="help-block"><?= Html::encode($model->getFirstError('phone')) ?></div>
        <?php endif; ?>
    </div>

    <?= $form->field($model, 'email')->textInput([
        'type' => 'email',
        'placeholder' => 'example@mail.ru'
    ]) ?>

    <?= $form->field($model, 'password')->passwordInput([
        'placeholder' => 'Минимум 7 символов'
    ]) ?>

    <?= $form->field($model, 'password_repeat')->passwordInput([
        'placeholder' => 'Повторите пароль'
    ]) ?>

    <?= $form->field($model, 'agree_terms')->checkbox([
        'template' => "<div class=\"form-check\">{input} {label}</div>\n{error}",
    ]) ?>

    <div class="form-group">
        <?= Html::submitButton('Создать пользователя', ['class' => 'btn btn-primary btn-block', 'name' => 'register-button']) ?>
    </div>

    <?php ActiveForm::end(); ?>

    <div class="form-link">
        <p>Уже зарегистрированы? <a href="<?= Yii::$app->urlManager->createUrl(['site/login']) ?>">Войти</a></p>
    </div>
</div>

<style>
.phone-input-container {
    position: relative;
}

.phone-format {
    font-size: 1.4vh;
    color: #20B2AA;
    margin-top: 0.5vh;
    text-align: center;
    font-weight: 500;
}

.phone-input {
    text-align: center;
    letter-spacing: 0.5px;
}

.phone-input:valid {
    border-color: #20B2AA;
    background-color: #f8fdfc;
}

.phone-input:invalid:not(:placeholder-shown) {
    border-color: #e74c3c;
    background-color: #fef7f7;
}

.phone-input:focus {
    border-color: #20B2AA;
    box-shadow: 0 0 0 3px rgba(32, 178, 170, 0.1);
}
</style>

<script>
function formatPhone(input) {
    // Удаляем все символы, кроме цифр
    let value = input.value.replace(/\D/g, '');
    
    // Форматируем номер
    if (value.length > 0) {
        // Начинаем с +7
        let formatted = '+7(';
        
        if (value.length > 1) {
            // Берем следующие 3 цифры (код оператора)
            let code = value.substring(1, 4);
            formatted += code;
            
            if (value.length > 4) {
                formatted += ')';
                let firstPart = value.substring(4, 7);
                formatted += firstPart;
                
                if (value.length > 7) {
                    formatted += '-';
                    let secondPart = value.substring(7, 9);
                    formatted += secondPart;
                    
                    if (value.length > 9) {
                        formatted += '-';
                        let thirdPart = value.substring(9, 11);
                        formatted += thirdPart;
                    }
                }
            }
        }
        
        input.value = formatted;
    }
}
</script>